/* eslint-disable vars-on-top */
define([
    'underscore',
    'App',
    'backbone',
    'modules/appointments/booked/booked-appointments-collection',
    'modules/appointments/requested/requested-appointments-collection',
    'modules/new-appointment-request/resources/constants',
    'modules/new-appointment-request/resources/request/express-care/collection',
    'modules/appointments/booked/cancel-reasons-collection',
    'moment',
    'app-resources',
], function (
    _,
    app,
    Backbone,
    Appointments,
    Requests,
    clinicalServicesConstants,
    ExpressCareReasons,
    CancelReasonsCollection,
    moment,
    appResources
) {
    'use strict';

    var STATUS_SUCCESS = 200;

    var today = moment();


    var defaultAppointmentFetchOptions = {
        data: {
            startDate: today.format('MM/DD/YYYY'),
        },
    };

    var defaultRequestFetchOptions = {
        data: {
            endDate: today.format('MM/DD/YYYY'),
            // eslint-disable-next-line no-magic-numbers
            startDate: today.subtract(120, 'days').format('MM/DD/YYYY'),
        },
    };

    var cancelReasons = {};
    var clinicProfiles = {};

    var appointmentsRequestDeferred = new $.Deferred();

    return {
        appointments: new (Appointments.extend({
            _readyFetchOptions: {
                data: { startDate: defaultAppointmentFetchOptions.data.startDate,
                },
                cache: false,
                remove: false,
            },
            _lastReadySiteCodes: [],

            isReady: function () {
                return appointmentsRequestDeferred;
            },

            /**
             * This fetch function is called by main.js once the patient identifiers have been found and then the
             * facilities associated with that user (dfn). This function creates a list of facility urls to load for
             * that user through the facility collection and resource. each url fetches the appointments for the logged
             * in user. The ccResource adds a url to fetch non dfn specific appointments and thus only needs one url.
             * This function is also called when the user clicks the refresh button on the app (not browser) in which
             * case the all parameters will be empty. thus we do not recreate nor update
             *      _lastReadyFacilityCollection
             *      _LastReadyResourceUrls
             * as they are assumed to be the same for a user.
             *
             * @param {collection} facilityCollection a collection of facilities associated with the logged in user.
             * @param {URL} resource the url to fetch a
             * facilities appointments
             * @param {URL} ccResource url to fetch a
             * users community care appointments
             * @param {Object} userURIComponents contains the assigning authority and id of the user
             * @returns {$.Deferred} the promise that all appointments were fetched.
             */
            // eslint-disable-next-line complexity
            fetchAppointmentData: function(facilityCollection, resource, ccResource, userURIComponents) {
                // first reset the promise and view's collection
                if (appointmentsRequestDeferred.state() !== 'pending') {
                    appointmentsRequestDeferred = new $.Deferred();
                    this.reset(undefined, {silent: true});
                }

                // facilityCollection and resource are optional
                // if not provided, the function will use
                // _lastReadyFacilityCollection and _lastReadyResourceUrls respectively
                if (!_.isUndefined(facilityCollection)) {
                    this._lastReadyFacilityCollection = facilityCollection;
                }
                if (!_.isUndefined(ccResource) && !_.isUndefined(userURIComponents)) {
                    this.ccAppointmentsUrl = ccResource.formatHref({
                        'assigning-authority': userURIComponents['assigning-authority'],
                        'patient-id': userURIComponents['patient-id'],
                    });
                }

                var enrolledSiteCodes = this._lastReadyFacilityCollection.pluck('facilityCode');

                if (!_.isUndefined(resource) && !_.isUndefined(userURIComponents)) {
                    this._lastReadyResourceUrls = _.map(enrolledSiteCodes, function(siteCode) {
                        return resource.formatHref({
                            'site-code': siteCode,
                            'assigning-authority': userURIComponents['assigning-authority'],
                            'patient-id': userURIComponents['patient-id'],
                        });
                    }, this);
                }

                // create an array of references to each fetch
                this.failedSiteCodes = [];

                // fetches to get booked appointments from each facility
                // a fetch is an array of ajax calls for each facility
                var fetches = this._lastReadyFacilityCollection.map(function(facility, index) {
                    var fetchOptions = _.clone(this._readyFetchOptions, true); // deep clone
                    fetchOptions.url = this._lastReadyResourceUrls[index];
                    // option.siteCode passed to model to associate appointment with facility
                    fetchOptions.siteCode = facility.get('facilityCode');
                    fetchOptions.facilityName = facility.get('name');
                    var configurations = app.configurations;
                    if ((configurations || {}).numberOfMonthsForFutureAppointments) {

                        var monthsOfData = configurations.numberOfMonthsForFutureAppointments;
                        var endDate = moment().add(monthsOfData, 'M');
                        fetchOptions.data.endDate = endDate.utc().format('MM/DD/YYYY');

                    }

                    // return a resolved state on successful or failed fetch
                    return this.fetchUrl(fetchOptions);
                }.bind(this));
                if (_.isUndefined(app.disabledFeatures.get('CC_FEATURE_SET'))) {
                    var ccFetch = _.clone(this._readyFetchOptions, true); // deep clone
                    ccFetch.url = this.ccAppointmentsUrl;
                    if ((app.configurations || {}).numberOfMonthsForFutureAppointments) {

                        var monthsOfData = app.configurations.numberOfMonthsForFutureAppointments;
                        var endDate = moment().add(monthsOfData, 'M');
                        ccFetch.data.endDate = endDate.utc().format('MM/DD/YYYY');

                    }
                    fetches.push(this.fetchUrl(ccFetch));
                }

                $.when.apply(this, fetches).always(function() {
                    // for each successful fetch, appointments are added via fetch()
                    // for each failed fetch, save failed facilities
                    _.each(fetches, function(fetch, index) {
                        if (fetch.state() === 'rejected') {
                            this.failedSiteCodes.push(enrolledSiteCodes[index]);
                        }
                    }, this);

                    appointmentsRequestDeferred.resolve();
                    this.trigger('ready');
                }.bind(this));

                return appointmentsRequestDeferred.promise();
            },
            fetchUrl: function(fetchOptions) {
                return (function() {
                    var deferred = new $.Deferred();
                    this.fetch(fetchOptions).always(function() {
                        deferred.resolve();
                    });
                    return deferred.promise();
                }.bind(this))();
            },
        }))(),
        requests: new (Requests.extend({
            _lastFetchOptions: _.clone(defaultRequestFetchOptions, true), // deep clone
            fetch: function(options) {
                var fetchOptions = options;
                if (!_.isUndefined(options) && options.reset) {
                    delete this.isReady;
                }

                if (_.isUndefined(this.isReady)) {
                    if (!_.isUndefined(options)) {
                        if (!_.isUndefined(options.url)) {
                            this._lastFetchOptions.url = options.url;
                        }
                        fetchOptions = _.extend({}, this._lastFetchOptions, options);
                    } else {
                        fetchOptions = this._lastFetchOptions;
                    }
                    this.isReady = Backbone.Collection.prototype.fetch.call(this, fetchOptions);
                }

                return this.isReady;
            },
        }))(),

        clinicalServicesConstants: clinicalServicesConstants,
        fetchClinicalServices: function() {
            var clinicalServicesCollection;

            // Only fetch from the server once
            if (!this.clinicalServicesPromise) {
                clinicalServicesCollection = new (Backbone.Collection.extend({
                    url: appResources.get('clinical-services').formatHref(),
                    comparator: function(model) {
                        if (model.get('id') === clinicalServicesConstants.PRIMARY_CARE_ID) {
                            // so that Primary Care is always first
                            return String.fromCharCode(0);
                        }
                        return model.get('name');

                    },
                }))();

                // When done fetching from the server, resolve the promise with the collection, itself
                this.clinicalServicesPromise = clinicalServicesCollection.fetch().then(function() {
                    return clinicalServicesCollection;
                });
            }

            return this.clinicalServicesPromise;
        },
        expressCareReasons: new (ExpressCareReasons.extend({
            _lastFetchOptions: {},

            // eslint-disable-next-line complexity
            fetch: function(options) {
                var fetchOptions = options;

                // eslint-disable-next-line max-len,no-mixed-operators
                if (!_.isUndefined(this.isReady) && this.isReady.status !== STATUS_SUCCESS || (!_.isUndefined(options) && options.reset)) {
                    delete this.isReady;
                }

                if (_.isUndefined(this.isReady)) {
                    if (!_.isUndefined(options)) {
                        if (!_.isUndefined(options.url)) {
                            this._lastFetchOptions.url = options.url;
                        }
                        fetchOptions = _.extend({}, this._lastFetchOptions, options);
                    } else {
                        fetchOptions = this._lastFetchOptions;
                    }
                    this.isReady = Backbone.Collection.prototype.fetch.call(this, fetchOptions);
                }

                return this.isReady;
            },
        }))(),
        fetchCancelReasons: function(options) {
            var siteCode = options.siteCode;

            if (_.isUndefined(cancelReasons[siteCode]) || this.cancelReasonsIsReady.status !== STATUS_SUCCESS) {
                delete this.cancelReasonsIsReady;
                cancelReasons[siteCode] = new CancelReasonsCollection();
                this.cancelReasonsIsReady = cancelReasons[siteCode].fetch(options);
            }

            return this.cancelReasonsIsReady;
        },
        cancelReasons: function(siteCode) {
            return cancelReasons[siteCode];
        },
        fetchClinicProfile: function(options) {
            var key = options.key;

            if (_.isUndefined(clinicProfiles[key]) || clinicProfiles[key].status !== STATUS_SUCCESS) {
                clinicProfiles[key] = $.ajax(options);
            }

            return clinicProfiles[key];
        },
    };
});
